printingError = .2;
thickness = 3;
leverLength = 70+40;
servoHornRadius = 3.6;
servoScrewRadius = 1;
hingeHoleRadiusRaw = 1.8;
hingeHoleRadius = printingError + hingeHoleRadiusRaw;
servoLeverOffsetRegionLength = 44;
servoLeverOffsetWidth = 15;
servoOvershoot = 10;
circularOffsetRadius = 11;
circularOffsetDistance = 4;

$fn = 200;
//$vpr = [55, 0, $t*360];
//$vpd = 546;

translate([0,0,0]){
    difference(){
        servoLeverArm();
        translate([0,leverLength/2.7,0]){
            servoEnd();
        }
    }
}

translate([-12,0,0]){
    rotate([0,0,180]){
        difference(){
            servoLeverArm();
            translate([0,leverLength/2.7,0]){
                servoEnd();
            }
        }
    }
}

translate([12,0,0]){
    hingeLeverArm();
}

translate([24,0,0]){
    hingeLeverArm();
}

module hingeLeverArm(){
    cube([thickness*2, leverLength, thickness], center = true);
    translate([0, leverLength/2 + hingeHoleRadius, 0]){
        difference(){
            cylinder(thickness, hingeHoleRadius + thickness/1.5, hingeHoleRadius + thickness/1.5, center = true);
            cylinder(thickness+1, hingeHoleRadius, hingeHoleRadius, center = true);
        }
    }
    translate([0, -(leverLength/2 + hingeHoleRadius), 0]){
        difference(){
            cylinder(thickness, hingeHoleRadius + thickness/1.5, hingeHoleRadius + thickness/1.5, center = true);
            cylinder(thickness+1, hingeHoleRadius, hingeHoleRadius, center = true);
        }
    }
}

module servoEnd(){
    translate([0,thickness*1.5,0]){
        cylinder(thickness+1, servoScrewRadius, servoScrewRadius, center = true);
    }
    translate([0,thickness*-1.5,0]){
        cylinder(thickness+1, servoScrewRadius, servoScrewRadius, center = true);
    }
    cube([servoScrewRadius*2, thickness*3, thickness+1], center = true);
}

module servoLeverArm(){
    cube([thickness*2, leverLength, thickness], center = true);
    translate([0, leverLength/2 + servoHornRadius + printingError, 0]){
        difference(){
            cylinder(thickness, servoHornRadius+thickness, servoHornRadius+thickness, center = true);
            cylinder(thickness+1, servoHornRadius + printingError, servoHornRadius + printingError, center = true);
        }
    }
    translate([0, -(leverLength/2 + hingeHoleRadius), 0]){
        difference(){
            cylinder(thickness, hingeHoleRadius + thickness/1.5, hingeHoleRadius + thickness/1.5, center = true);
            cylinder(thickness+1, hingeHoleRadius, hingeHoleRadius, center = true);
        }
    }
}